---
title: Face Swap API Usage Guide
slug: eC4eIgRJKwIGIsmMqAH4l
createdAt: Thu Jul 18 2024 06:04:57 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:43:11 GMT+0000 (Coordinated Universal Time)
---

# AI Face Swap API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the AI Face Swap API.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
    input: {
        "swap_image": "https://aonweb.ai/pbxt/JoBuzfSVFLb5lBqkf3v9xMnqx3jFCYhM5JcVInFFwab8sLg0/long-trench-coat.png",
        "target_image": "https://replicate.delivery/pbxt/JoBuz3wGiVFQ1TDEcsGZbYcNh0bHpvwOi32T1fmxhRujqcu7/9X2.png"
    }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/face-swap@omniedgeio", data, price);
    // Handle response
    console.log("Face swap result:", response);
} catch (error) {
    // Error handling
    console.error("Error performing face swap:", error);
}
```

### Parameter Description

- `swap_image`: URL of the image containing the face to be swapped.
- `target_image`: URL of the target image where the face will be swapped.

### Notes

- Ensure that the provided image URLs are publicly accessible.
- The API may take some time to process the images, consider implementing appropriate wait or retry logic.
- Handle possible errors, such as network issues or API limitations.

### Example Response

The API response will contain the URL of the processed image or other relevant information. Parse and use the response data according to the actual API documentation.